<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\AdminLoginController;
use App\Http\Controllers\admin\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SiteSettingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AdminListController;
use App\Http\Controllers\AgentExampleController;
use App\Http\Controllers\SuperListController;
use App\Http\Controllers\MasterListController;
use App\Http\Controllers\CustomerListController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\SubAdminListController;
use App\Http\Controllers\SliderController;

Route::get('/',[HomeController::class,'index'])->name('home');


Route::group(['prefix' => 'admin'],function(){

    Route::group(['middleware' => 'admin.guest'],function(){
        Route::get('/login',[AdminLoginController::class,'index'])->name('admin.login');
        Route::post('/authenticate',[AdminLoginController::class,'authenticate'])->name('admin.authenticate');
    });

    Route::group(['middleware' => 'admin.auth'],function(){
        Route::get('/dashboard',[DashboardController::class,'index'])->name('admin.dashboard');
        Route::get('/logout',[DashboardController::class,'logout'])->name('admin.logout');
        Route::post('/updateSiteSettings',[SiteSettingsController::class,'updateHeader'])->name('updateSiteSettings');
        Route::post('/autodepositupdateSiteSettings',[SiteSettingsController::class,'autodepositupdateSiteSettings'])->name('autodepositupdateSiteSettings');
        Route::get('/change/password',[ProfileController::class,'profileSettings'])->name('profileSettings');
        Route::post('/profileUpdate',[ProfileController::class,'profileUpdate'])->name('profileUpdate');
        Route::get('/siteSettings',[SiteSettingsController::class,'header'])->name('siteSettings');
        Route::get('/sites',[DashboardController::class,'sites'])->name('sites');
        Route::post('/siteUpdate/{id}',[DashboardController::class,'siteUpdate'])->name('siteUpdate');
        Route::post('/siteDelete/{id}',[DashboardController::class,'siteDelete'])->name('siteDelete');
        Route::post('/siteStore',[DashboardController::class,'siteStore'])->name('siteStore');
        Route::post('/exampleSettings',[SiteSettingsController::class,'exampleSettings'])->name('exampleSettings');
        Route::post('/exampleSettingsdetail',[SiteSettingsController::class,'exampleSettingsdetail'])->name('exampleSettingsdetail');
        Route::resource('slider', SliderController::class);
    });
});
