@extends('admin.master')

@section('title')
    Sliders
@endsection

@section('content')

    <div class="container-fluid">

        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">All Sliders</h1>
        </div>
        <div class="row">

            @include('admin.auth.message')
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="alert-ul">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h4 class="">Sliders</h4>
                    <a class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addNew"><i
                            class="bi bi-pen-fill"></i> Add New Slider</a>
                </div>
                <div class="card-body" style="padding: 0px !important">
                    <table class="table table-bordered table-hover table-striped table-responsive-md zero-configuration">
                        <thead>
                            <tr>
                                <th>Sl</th>
                                <th>Sliders Image</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($sliders->isNotEmpty())
                                @foreach ($sliders as $slider)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td> <img src="{{ asset($slider->image) }}" alt="" width="100px" > </td>
                                        
                                        <td class="table-action-td d-flex align-items-center column-gap-3">
                                            <a class="btn btn-sm btn-primary" data-toggle="modal"
                                                data-target="#EditRegistrationModal_{{ $slider->id }}"><i
                                                    class="bi bi-pen-fill"></i> Edit</a>
                                            <form action="{{ route('slider.destroy', $slider->id) }}" method="POST"
                                                onsubmit="return confirm('Are you sure you want to delete this slider?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"><i
                                                        class="bi bi-trash-fill"></i> Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5"> No slider Found !!! </td>
                                </tr>
                            @endif

                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>


<div class="modal fade" id="addNew" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>Add New slider </h5>
                <button class="btn btn-danger" data-dismiss="modal">Close</button>
            </div>
            <div class="modal-body">
                <form action="{{ route('slider.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Upload Slider Image</label>
                        <input type="file" class="form-control" name="image" accept="image/*" >
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>



@if(isset($slider))
    @foreach($sliders as $slider)
    <div class="modal fade" id="EditRegistrationModal_{{ $slider->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <!-- Modal content goes here, make sure to customize it for each category -->
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header d-flex w-100 align-items-center justify-content-between">
                    Edit slider
                    <button class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('slider.update', $slider->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        
                        <div class="form-group">
                            <label for="exampleInputEmail1">Upload slider Image</label>
                            <input type="file" class="form-control" name="image" accept="image/*" >
                            <p class="my-2"> Previous Image: </p>
                            <img src="{{ asset($slider->image) }}" width="100px" alt="">
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
    @endforeach
@endif




@endsection

@section('customjs')
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/jquery.dataTables.min.js"></script>
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/datatable/dataTables.bootstrap4.min.js"></script>
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/datatable-init/datatable-basic.min.js"></script>
@endsection
