
@extends('admin.master')

@section('title')
     Admin Dashboard
@endsection

@section('content')
    <style>
        .text-gray-300 {
            display: none !important;
        }
        .col-xl-3,.col-md-6{
            width: 47% !important;
            margin: 5px 5px !important;
        }
        .col-auto{
            width: 100% !important;
        }
    </style>
    <div class="container-fluid">

        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        </div>
        <div class="">
            @include('admin.auth.message')
        <div class="row ">
            <div class="col-md-12">
                <form method="post" action="{{ route('updateSiteSettings') }}" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" value="{{ $siteSettings->id }}">
                    <div class="card" style="margin-top: 0px !important;">
                        <div class="card-header">
                            <h5 class="text-black">General Settings</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div>
                                        <h4 class="">Logo</h4>
                                        <img src="{{ asset($siteSettings->logo) }}" class="py-3" height="100px" width="50%">

                                        <input type="file" class="form-control" name="logo" accept="image/*">
                                    </div>
                                </div>
                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Favicon</h4>
                                        <img src="{{ asset($siteSettings->favicon) }}" class="py-3" height="100px" width="50%"><br>

                                        <input type="file" class="form-control" name="favicon" accept="image/*">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div>
                                        <h4>Site Image</h4>
                                        <img src="{{ asset($siteSettings->site_image) }}" class="py-3" height="100px" width="50%"><br>

                                        <input type="file" class="form-control" name="site_image" accept="image/*">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Image 2</h4>
                                        <img src="{{ asset($siteSettings->site_image2) }}" class="py-3" height="100px" width="50%"><br>

                                        <input type="file" class="form-control" name="site_image2" accept="image/*">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Image 3</h4>
                                        <img src="{{ asset($siteSettings->site_image3 ) }}" class="py-3" height="100px" width="50%"><br>

                                        <input type="file" class="form-control" name="site_image3" accept="image/*">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Video 1</h4>
                                        {!! $siteSettings->video1 !!}

                                        <input type="text" name="video1" class="form-control" value="{{ $siteSettings->video1 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Video 2</h4>
                                        {!! $siteSettings->video2 !!}

                                        <input type="text" name="video2" class="form-control" value="{{ $siteSettings->video2 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Video 3</h4>
                                        {!! $siteSettings->video3 !!}

                                        <input type="text" name="video3" class="form-control" value="{{ $siteSettings->video3 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Video 4</h4>
                                        {!! $siteSettings->video4 !!}

                                        <input type="text" name="video4" class="form-control" value="{{ $siteSettings->video4 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Video 5</h4>
                                        {!! $siteSettings->video5 !!}

                                        <input type="text" name="video5" class="form-control" value="{{ $siteSettings->video5 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Title</h4>
                                        <input type="text" name="site_title" class="form-control" value="{{ $siteSettings->site_title }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site News</h4>
                                        <input type="text" name="news" class="form-control" value="{{ $siteSettings->news }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Register Link</h4>
                                        <input type="text" name="link" class="form-control" value="{{ $siteSettings->link }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Affiliate Link</h4>
                                        <input type="text" name="affiliate_link" class="form-control" value="{{ $siteSettings->affiliate_link }}" >
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Link 1</h4>
                                        <input type="text" name="site_link" class="form-control" value="{{ $siteSettings->site_link }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Link 2</h4>
                                        <input type="text" name="site_link2" class="form-control" value="{{ $siteSettings->site_link2 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4>Site Link 3</h4>
                                        <input type="text" name="site_link3" class="form-control" value="{{ $siteSettings->site_link3 }}">
                                    </div>
                                </div>

                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4 class="">WhatsApp Number</h4>
                                        <input type="number" name="whatsapp" class="form-control" value="{{ $siteSettings->whatsapp }}">
                                    </div>
                                </div>
                                <div class="col-md-12 py-3">
                                    <div>
                                        <h4 class="">WhatsApp Number 2</h4>
                                        <input type="number" name="whatsapp2" class="form-control" value="{{ $siteSettings->whatsapp2 }}">
                                    </div>
                                </div>
                                

                                <div class="col-md-12 mt-3">
                                    <button type="submit" class="btn btn-primary w-50">Save settings</button>
                                </div>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
        </div>
    </div>




@endsection
@section('customjs')
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/jquery.dataTables.min.js"></script>
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/datatable/dataTables.bootstrap4.min.js"></script>
    <script src="{{ asset('admin-assets') }}/plugins/tables/js/datatable-init/datatable-basic.min.js"></script>

@endsection
