<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteSetting extends Model
{
    use HasFactory;
    private static $setting,$image, $imageNewName, $dir, $imageUrl, $action;

    public static function updateHeader($request){
        self::$setting = SiteSetting::find($request->id);
        self::$action = 'saved';
        if ($request->file('logo')){
            if (self::$setting->logo){
                if (file_exists(self::$setting->logo)){
                    unlink(self::$setting->logo);
                }
            }
            self::$setting->logo = self::saveLogo($request);
        }
        if ($request->file('favicon')){
            if (self::$setting->favicon){
                if (file_exists(self::$setting->favicon)){
                    unlink(self::$setting->favicon);
                }
            }
            self::$setting->favicon = self::saveFavicon($request);
        }
        if ($request->file('site_image')){
            if (self::$setting->site_image){
                if (file_exists(self::$setting->site_image)){
                    unlink(self::$setting->site_image);
                }
            }
            self::$setting->site_image = self::saveImage($request);
        }
        if ($request->file('site_image2')){
            if (self::$setting->site_image2){
                if (file_exists(self::$setting->site_image2)){
                    unlink(self::$setting->site_image2);
                }
            }
            self::$setting->site_image2 = self::saveImage2($request);
        }
        if ($request->file('site_image3')){
            if (self::$setting->site_image3){
                if (file_exists(self::$setting->site_image3)){
                    unlink(self::$setting->site_image3);
                }
            }
            self::$setting->site_image3 = self::saveImage3($request);
        }

        self::$setting->site_title = $request->site_title;
        self::$setting->video1 = $request->video1;
        self::$setting->video2 = $request->video2;
        self::$setting->video3 = $request->video3;
        self::$setting->video4 = $request->video4;
        self::$setting->video5 = $request->video5;
        self::$setting->link = $request->link;
        self::$setting->news = $request->news;
        self::$setting->Site_Text = $request->Site_Text;
        self::$setting->whatsapp = $request->whatsapp;
        self::$setting->whatsapp2 = $request->whatsapp2;
        self::$setting->site_link = $request->site_link;
        self::$setting->site_link2 = $request->site_link2;
        self::$setting->site_link3 = $request->site_link3;
        self::$setting->facebook_page = $request->facebook_page;
        self::$setting->facebook_group = $request->facebook_group;
        self::$setting->affiliate_link = $request->affiliate_link;

        self::$setting->save();

        $successMessage = "Site Settings has been " . self::$action . " successfully";
        $request->session()->flash('success', $successMessage);
    }



    public static function saveLogo($request){
        self::$image = $request->file('logo');
        self::$imageNewName = "logo".rand().'.'.self::$image->extension();
        self::$dir = "admin-assets/img/products/";
        self::$imageUrl = self::$dir.self::$imageNewName;
        self::$image->move(self::$dir,self::$imageUrl);
        return self::$imageUrl;
    }
    public static function saveFavicon($request){
        self::$image = $request->file('favicon');
        self::$imageNewName = "favicon".rand().'.'.self::$image->extension();
        self::$dir = "admin-assets/img/products/";
        self::$imageUrl = self::$dir.self::$imageNewName;
        self::$image->move(self::$dir,self::$imageUrl);
        return self::$imageUrl;
    }

    public static function saveImage($request){
        self::$image = $request->file('site_image');
        self::$imageNewName = "site_image".rand().'.'.self::$image->extension();
        self::$dir = "admin-assets/img/products/";
        self::$imageUrl = self::$dir.self::$imageNewName;
        self::$image->move(self::$dir,self::$imageUrl);
        return self::$imageUrl;
    }

    public static function saveImage2($request){
        self::$image = $request->file('site_image2');
        self::$imageNewName = "site_image2".rand().'.'.self::$image->extension();
        self::$dir = "admin-assets/img/products/";
        self::$imageUrl = self::$dir.self::$imageNewName;
        self::$image->move(self::$dir,self::$imageUrl);
        return self::$imageUrl;
    }

    public static function saveImage3($request){
        self::$image = $request->file('site_image3');
        self::$imageNewName = "site_image3".rand().'.'.self::$image->extension();
        self::$dir = "admin-assets/img/products/";
        self::$imageUrl = self::$dir.self::$imageNewName;
        self::$image->move(self::$dir,self::$imageUrl);
        return self::$imageUrl;
    }



}
