<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SubAdminMiddleware
{
    protected function redirectTo(Request $request): ?string
    {
        return $request->expectsJson() ? null : route('admin.login');
    }

    protected function authenticate($request, array $guards)
    {
        $user = $this->auth->guard('admin')->user();

        if ($user && $user->role === 0) {
            return $this->auth->shouldUse('admin');
        }

        $this->unauthenticated($request, ['sub-admin']);
    }
}
