<?php

namespace App\Http\Controllers;

use App\Models\SiteSetting;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $sliders = Slider::all();
        $siteSettings = SiteSetting::find(1);
        return view('admin.sliders.index', compact('sliders','siteSettings'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function store(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            
            'image' => 'required',
           
        ]);

        // If validation fails, redirect back with errors and old input
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $Slider = new Slider();

        if ($request->file('image')){
            if ($Slider->image){
                if (file_exists($Slider->image)){
                    unlink($Slider->image);
                }
            }
            $Slider->image = self::saveLogo($request);
        }
        $Slider->heading = $request->heading;
        $Slider->description = $request->description;
        $Slider->link = $request->link;
        $Slider->save();

        // Redirect back with a success message
        return back()->with('success', 'Slider added successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $validator = Validator::make($request->all(), [
            
            'image' => 'nullable',
           
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $Slider = Slider::findOrFail($id);
        if ($request->file('image')){
            if ($Slider->image){
                if (file_exists($Slider->image)){
                    unlink($Slider->image);
                }
            }
            $Slider->image = self::saveLogo($request);
        }
        $Slider->heading = $request->heading;
        $Slider->description = $request->description;
        $Slider->link = $request->link;
        $Slider->save();

        return back()->with('success', 'Slider updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $Slider = Slider::find($id);
        if ($Slider && $Slider->image && file_exists($Slider->image)) {
            unlink($Slider->image);
        }
        $Slider->delete();

        return back()->with('success', 'Slider List deleted successfully!');
    }
    public static function saveLogo($request){
        $image = $request->file('image');
        $imageNewName = $request->name.rand().'.'.$image->extension();
        $dir = "admin-assets/img/sliders/";
        $imageUrl = $dir.$imageNewName;
        $image->move($dir,$imageUrl);
        return $imageUrl;
    }
}
